;***********************************************************************************************************************
;*   INTERRUPTS.asm   "SUPER JOYSTICK PORT 2"
;* (C) 2015  
;* 150214-03
;***********************************************************************************************************************
;***********************************************************************************************************************
;* 150214-03                               
;***********************************************************************************************************************
.org    $000
        rjmp Main                       ; Reset Handler            -    
reti;   rjmp EXT_INT0                   ; IRQ0 Handler
reti;   rjmp EXT_INT1                   ; IRQ1 Handler             -   PS2/
reti;   rjmp PCINT0                     ; PCINT0 Handler
reti;   rjmp PCINT1                     ; PCINT1 Handler
reti;   rjmp PCINT2                     ; PCINT2 Handler
reti;   rjmp WDT                        ; Watchdog Timer Handler
reti;   rjmp TIM2_COMPA                 ; Timer2 Compare A Handler
reti;   rjmp TIM2_COMPB                 ; Timer2 Compare B Handler
reti;   rjmp TIM2_OVF                   ; Timer2 Overflow Handler
reti;   rjmp TIM1_CAPT                  ; Timer1 Capture Handler
reti;   rjmp TIM1_COMPA                 ; Timer1 Compare A Handler
reti;   rjmp TIM1_COMPB                 ; Timer1 Compare B Handler
reti;   rjmp TIM1_OVF                   ; Timer1 Overflow Handler
        rjmp TIM0_COMPA                 ; Timer0 Compare A Handler -    SEGA 
reti;   rjmp TIM0_COMPB                 ; Timer0 Compare B Handler
reti;   rjmp TIM0_OVF                   ; Timer0 Overflow Handler
reti;   rjmp SPI_STC                    ; SPI Transfer Complete Handler
reti;   rjmp USART_RXC                  ; USART, RX Complete Handler
reti;   rjmp USART_UDRE                 ; USART, UDR Empty Handler
reti;   rjmp USART_TXC                  ; USART, TX Complete Handler
reti;   rjmp ADC                        ; ADC Conversion Complete Handler
reti;   rjmp EE_RDY                     ; EEPROM Ready Handler
reti;   rjmp ANA_COMP                   ; Analog Comparator Handler
reti;   rjmp TWI                        ; 2-wire Serial Interface Handler
reti;   rjmp                            ; SPM_RDYStore Program Memory Ready

;***********************************************************************************************************************
;* 150214-03                                0
;***********************************************************************************************************************
TIM0_COMPA:
        SAVE_SREG                       ;  SREG
        inc     cnt_tim0                ;     

        cpi     cnt_tim0,9              ; ,     9
        brsh    Tim0_90

        cpi     cnt_tim0,1              ;      1  8
        breq    Tim0_10
        cpi     cnt_tim0,2
        breq    Tim0_20
        cpi     cnt_tim0,3
        breq    Tim0_30
        cpi     cnt_tim0,4
        breq    Tim0_40
        cpi     cnt_tim0,5
        breq    Tim0_50
        cpi     cnt_tim0,6
        breq    Tim0_60
        cpi     cnt_tim0,7
        breq    Tim0_70
        cpi     cnt_tim0,8
        breq    Tim0_80
        rjmp    Tim0_End

Tim0_10:
        CLR_SEGA_SYN
        rjmp     Tim0_End

Tim0_20:
        SET_SEGA_SYN
        rjmp     Tim0_End

Tim0_30:
        CLR_SEGA_SYN
        rjmp     Tim0_End

Tim0_40:
        SET_SEGA_SYN
        rjmp     Tim0_End

Tim0_50:
        CLR_SEGA_SYN
        rjmp     Tim0_End

Tim0_60:
        SET_SEGA_SYN
        rjmp     Tim0_End

Tim0_70:
        CLR_SEGA_SYN
        rjmp     Tim0_End

Tim0_80:
        SET_SEGA_SYN
        rjmp     Tim0_End

Tim0_90:
        cpi      cnt_tim0,48            ;    48 - 
        brne     Tim0_End
        ldi      cnt_tim0,0

Tim0_End:
        LOAD_SREG                       ;  SREG
        reti

;***********************************************************************************************************************
